require "class"
require "screens/pausescreen"
local easing = require "easing"

local trace = function() end

local CLICK_WALK_TIME = .5

local prefabs =
{
}


local playercontroller_camera = Class(function(self, inst)
    self.inst = inst
    self.enabled = true
    	
	self.camfocus = 0
	self.playerfocus = 0

	
    self.inputhandlers = {}

	
	
	
	
	table.insert(self.inputhandlers, TheInput:AddKeyDownHandler(KEY_X, function() self:SpawnPlayer2() end))
	table.insert(self.inputhandlers, TheInput:AddKeyDownHandler(KEY_KP_MINUS, function() self:SpawnPlayer2() end))
	
	
	
    table.insert(self.inputhandlers, TheInput:AddKeyUpHandler(KEY_Z, function() self:CameraFocus() end))---7
    self.inst:StartUpdatingComponent(self)
    self.draggingonground = false
    self.startdragtestpos = nil
    self.startdragtime = nil
	
end)



function playercontroller_camera:CameraFocus()
    self.camfocus = 0
    
    if self.playerfocus == 0 then
        self.playerfocus = 1
    elseif self.playerfocus == 1 then
        self.playerfocus = 0
    else
        self.playerfocus = 0
    end
    
end

function playercontroller_camera:SpawnPlayer2()
	self.inst:DoTaskInTime(1, function() 
	
    self.inst.components.health:DoDelta(900000)
    self.camfocus = 1
	
	end)
end




function playercontroller_camera:OnUpdate(dt)
    local player1 = GetPlayer()
    local player2 = FindEntity(self.inst, 100, function(guy) return (guy.components.playercontroller_3)end)
    self.time = 0
    if player2 then
        if self.camfocus == 1 then
            local pt = player1:GetPosition()
            local pt2 = player2:GetPosition()
        
            self.inst.Transform:SetPosition(pt.x, pt.y, pt.z)
            TheCamera:SetTarget(player1)
            TheCamera:SetDistance(35)
            local posx = (pt.x + pt2.x)*0.5
            local posy = (pt.y + pt2.y)*0.5
            local posz = (pt.z + pt2.z)*0.5
        
            local dist = player1:GetDistanceSqToInst(player2)*0.1
        
            if dist < 35 then
                dist = 35
            end
        
            if dist > 60 then
                dist = 60
            end
        
            local distf = (dist^-1)*14
            TheCamera:SetDistance(((dist*1.1)+distf))
            TheCamera:SetTarget(self.inst)
            self.inst.Transform:SetPosition(posx, posy, posz)
            if (player1:GetDistanceSqToInst(player2) > (40*40)) then
				player2:AddTag("moveblocked")
			--	print("playercontroller_3 == DISABLED")
                local pt = player1:GetPosition()
				if (player1.components.driver and player1.components.driver.driving ==false)
				and (player2.components.driver and player2.components.driver.driving ==true) then
					player2.components.playercontroller_3:UnMountBoat(true)
					--player2.components.driver:OnDismount(nil, player2:GetPosition())
					self.time =  self.time +1
					print("107 time =  "..self.time)
				end
				self.time =  self.time +1
				print("110 time =  "..self.time)
				if self.time>15 then
					player2.Transform:SetPosition(pt.x, pt.y, pt.z)
					self.time = 0
				end
			elseif  self.time>0 or player2:HasTag("moveblocked") then
				self.time = 0
				player2:RemoveTag("moveblocked")
            end
        else
            if self.playerfocus == 0 then
                local pt = player1:GetPosition()
                self.inst.Transform:SetPosition(pt.x, pt.y, pt.z)
                TheCamera:SetTarget(player1)
                TheCamera:SetDistance(35)
            elseif self.playerfocus == 1 then
                local pt = player1:GetPosition()
                self.inst.Transform:SetPosition(pt.x, pt.y, pt.z)
                TheCamera:SetTarget(player1)
                TheCamera:SetDistance(35)
            else
                self.playerfocus = 0
            end
        end
    else
        if (self.inst:GetDistanceSqToInst(player1) > (1*1)) then
            local pt = player1:GetPosition()
            self.inst.Transform:SetPosition(pt.x, pt.y, pt.z)
            TheCamera:SetTarget(player1)
            TheCamera:SetDistance(35)
        end
    end
end



return playercontroller_camera
